(defclass component
	(is-a USER)
	(role abstract)
	(slot suspect 
		(type SYMBOL) 
		(allowed-symbols yes no)
		(default no))
)


(defclass sensor
	(is-a component)
	(role concrete)
	(pattern-match reactive)
)

(defclass internal-component
	(is-a component)
	(role concrete)
	(pattern-match reactive)
	(multislot connects_with
		(type INSTANCE-NAME) )
)

(definstances sensors
	(m1 of sensor)
	(m2 of sensor)
	(m3 of sensor)
	(m4 of sensor)
	(m5 of sensor)
)

(definstances internal-components
	(s14 of internal-component (connects_with [m5]))
	(s21 of internal-component (connects_with [m1] [m2]))
	(s22 of internal-component (connects_with [m2] [m3]))
	(s23 of internal-component (connects_with [m3] [m4]))
	(s11 of internal-component (connects_with [s21] [s22]))
	(s12 of internal-component (connects_with [s22]))
	(s13 of internal-component (connects_with [s23] [m5]))
)

(defrule initial-question
	?x <- (initial-fact)
  =>
	(retract ?x)
  	(bind $?sensors (find-all-instances ((?s sensor)) TRUE))
	(set-strategy mea)
	(printout t "Which sensors show discrepancy? " $?sensors " ")
	(bind $?answer (explode$ (readline)))
	(assert (discrepancy $?answer))
	(assert (goal make-suspects))
)

(defrule init-suspects
	(goal make-suspects)
	(discrepancy $? ?s $?)
	(object (is-a sensor) (name =(symbol-to-instance-name ?s)) (suspect no))
  =>
	(modify-instance (symbol-to-instance-name ?s) (suspect yes))
)

(defrule propagate-suspect
	(goal make-suspects)
	(object (is-a component) (name ?c) (suspect yes))
	(object (is-a internal-component) (name ?c1) (connects_with $? ?c $?) (suspect no))
  =>
	(modify-instance ?c1 (suspect yes))
)


(defrule make-suspects-continue
	?x <- (goal make-suspects)
  =>
	(retract ?x)
	(assert (goal exonerate-components))
)

(defrule exonerate-components
	(goal exonerate-components)
	(object (is-a internal-component) (name ?c1) (suspect yes) (connects_with $? ?c $?))
	(object (is-a component) (name ?c) (suspect no))
  =>
	(modify-instance ?c1 (suspect no))
)

(defrule exonerate-components-special
	(goal exonerate-components)
	(object (is-a internal-component) (name ?c) (suspect yes) (connects_with ?s))
	(object (is-a sensor) (name ?s) (suspect yes))
	(object (is-a sensor) (name ~?s) (suspect yes))
  =>
	(modify-instance ?c (suspect no))
)

(defrule exonerate-components-continue
	?x <- (goal exonerate-components)
  =>
	(retract ?x)
	(assert (goal announce-result))
)

(defrule announce-result
	(goal announce-result)
	(object (is-a component) (name ?c) (suspect yes))
	(not (object (is-a internal-component) (name ~?c) (suspect yes) (connects_with $? ?c $?)))
  =>
	(printout t (class ?c) " " (instance-name-to-symbol ?c) " malfunctions!" crlf)
)
